    NAME OsScreen

; This is Os.Screen.Asm.

CGROUP GROUP CODE

EXTRN  ttr10x12: BYTE

PUBLIC CpAddrOfSystemFont
PUBLIC SetScreenMode
PUBLIC CpScreenInfo


CODE SEGMENT PUBLIC 'CODE'
  ASSUME CS:CGROUP

;   CpAddrOfSystemFont
;
;  This routine returns a pointer to the built-in system font
;

CpAddrOfSystemFont PROC FAR
  MOV  BX, SEG ttr10x12
  MOV  ES, BX
  MOV  BX, OFFSET ttr10x12
  RET
CpAddrOfSystemFont ENDP


  gTable  DB 35h, 2dh, 2eh, 07h
          DB 5bh, 02h, 57h, 57h
          DB 02h, 03h, 00h, 00h

SetMd  PROC NEAR
; Sets the mode to graphics or text
; depending on AL
; SI = parameter table
; CX = number of words to be cleared
; BX = blank value
  
  PUSH DS
  PUSH ES
  PUSH AX
  PUSH BX
  PUSH CX

; Change mode but without screen on
  MOV  DX, 3b8h
  OUT  DX, AL

; Initialize the 6845
  MOV AX, CS
  MOV DS, AX
  MOV ES, AX

  MOV DX, 3b4h
  MOV CX, 12
  XOR AH, AH

  CLD               ; Phil, don't forget next time !!!

Parms:
  MOV AL, AH
  OUT DX, AL
  INC DX
  LODSB
  OUT DX, AL

  INC AH            ; next value
  DEC DX
  LOOP Parms

  POP CX            ; clear the buffer
  MOV AX, 0b000h
  CLD
  MOV ES, AX
  XOR DI, DI
  POP AX
  REP STOSW

; Screen on page 0

  MOV DX, 3b8h
  POP AX
  ADD AL, 8        ; screen on
  OUT DX, AL

  POP ES
  POP DS
  RET
SetMd ENDP
$EJECT

;   SetScreenMode: PROCEDURE CLEAN;
;
;  This routine will set the screen to Hercules Graphics mode
;

SetScreenMode PROC FAR
  PUSH  DS
  MOV   AL, 2
  MOV   SI, OFFSET CGROUP:gTable
  MOV   BX, 0
  MOV   CX, 4000h
  CALL  SetMd
  POP   DS
  RET
SetScreenMode ENDP  

$EJECT

;    CpScreenInfo : PROCEDURE (pInfo) CLEAN;
;      DCL pInfo     PTR;
;      DCL info      BASED pInfo  ScreenInfoType;
;
;    This will return information about screen size, etc.

ScreenInfoType STRUC
  xPixels    DW ?
  yPixels    DW ?
  pScreenOff DW ?
  pScreenSeg DW ?
  bitsPerPel DB ?
  yAspect    DW ?
ScreenInfoType ENDS

screenInfo  EQU ES:[DI]
pScreenInfo  EQU DWORD PTR [BP+6]

$LIST
CpScreenInfo PROC FAR
  PUSH BP
  MOV  BP, SP

  LES  DI, pScreenInfo
  MOV  screenInfo.xPixels, 720
  MOV  screenInfo.yPixels, 348
  MOV  screenInfo.yAspect, 100
  MOV  screenInfo.pScreenSeg, 0B000h

;  MOV  screenInfo.xPixels, 640
;  MOV  screenInfo.yPixels, 200
;  MOV  screenInfo.yAspect, 140
;  MOV  screenInfo.pScreenSeg, 0B800h

  MOV  screenInfo.pScreenOff, 0
  MOV  screenInfo.bitsPerPel, 1

  POP  BP
  RET  4
CpScreenInfo ENDP
$NOLIST
PURGE screenInfo
PURGE pScreenInfo
PURGE ScreenInfoType
PURGE xPixels
PURGE yPixels
PURGE pScreenOff
PURGE pScreenSeg
PURGE bitsPerPel
PURGE yAspect

CODE ENDS

    END
